# !/bin/bash
# metrics_report.sh

start_date="2015-01-01"
end_date="2015-03-31"

#Known production outage durations in seconds
EVENTS=(30 300)

#Certificate to use for authenticated access
AUTHCERT="${HOME}/.dataone/ssl/private/cnode_client.pem"

start_date_solr="${start_date}T00%3A00%3A00.000Z"
end_date_solr="${end_date}T23%3A59%3A59.000Z"

echo "Start = ${start_date_solr}"
echo "End = ${end_date_solr}"

# READ events, excluding CNs
nREAD=$(curl -k -s  "https://cn.dataone.org/cn/v1/query/logsolr/select?q=formatType%3ADATA%20AND%20event%3Aread%20AND%20dateLogged%3A%5B${start_date_solr}%20TO%20${end_date_solr}%5D%20AND%20-ipAddress%3A(128.111.54.80%20OR%20160.36.13.150%20OR%2064.106.40.6)" | xml sel -t -m "//result" -v "@numFound" -n)
echo "READ = ${nREAD}"

# CREATE events from log aggregation
nCREATE=$(curl -k -s "https://cn.dataone.org/cn/v1/query/logsolr/select?q=formatType%3ADATA%20AND%20event%3Acreate%20AND%20dateLogged%3A%5B${start_date_solr}%20TO%20${end_date_solr}%5D" | xml sel -t -m "//result" -v "@numFound" -n)
echo "CREATE = ${nCREATE}"

# Content added from the search index
nADDED=$(curl -k -s "https://cn.dataone.org/cn/v1/query/solr/?q=dateUploaded:%5B${start_date_solr}%20TO%20${end_date_solr}%5D%20AND%20formatType:DATA&facet=true&facet.field=datasource&rows=0" | xml sel -t -m "//result" -v "@numFound" -n)
echo "Added = ${nADDED}"

# Number of Member Nodes from Node List
nMNs=$(curl -k -s "https://cn.dataone.org/cn/v1/node" | xml sel -t -m "//node[@type='mn']" -v "identifier" -n | wc -l)
echo "Number of MNs = ${nMNs}"

# Number of public data objects
nPUB_DATA=$(curl -k -s "https://cn.dataone.org/cn/v1/query/solr/?q=formatType:DATA&rows=0" | xml sel -t -m "//result[@name='response']" -v "@numFound" -n)

# Number of all data objects
nDATA=$(curl -k -s --cert ${AUTHCERT} "https://cn.dataone.org/cn/v1/query/solr/?q=formatType:DATA&rows=0" | xml sel -t -m "//result[@name='response']" -v "@numFound" -n)

echo "Public, total data objects: ${nPUB_DATA}, ${nDATA}"

# Number of public metadata objects
nPUB_DATA=$(curl -k -s "https://cn.dataone.org/cn/v1/query/solr/?q=formatType:METADATA&rows=0" | xml sel -t -m "//result[@name='response']" -v "@numFound" -n)

# Number of all metadata objects
nDATA=$(curl -k -s --cert ${AUTHCERT} "https://cn.dataone.org/cn/v1/query/solr/?q=formatType:METADATA&rows=0" | xml sel -t -m "//result[@name='response']" -v "@numFound" -n)

# Uptime in percent from the start of production
T0=$(date -j -u -f %Y-%m-%d-%H-%M-%S 2012-07-01-12-00-00 +%s)
#T1=$(date -j -u -f %Y-%m-%d-%H-%M-%S 2014-12-31-23-59-59 +%s)
T1=$(date -j -u +%s)
PERIOD=$( bc <<< "$T1-$T0" )
DOWNTIME=$( IFS="+"; bc <<< "${EVENTS[*]}" )
UPTIME=$( bc <<< "scale=5;100.0*($PERIOD-$DOWNTIME)/$PERIOD")
echo "Uptime = ${UPTIME}"

